/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.servlet.logd.ExpanderData;
import com.ibm.hwmca.fw.servlet.logd.GetExpanderData;
import com.ibm.hwmca.fw.servlet.logd.LogServlet;
import com.ibm.hwmca.fw.servlet.logd.LogServletMsg;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SystemEventExpander {
    private static final String TRACE_MASKT = "XLDSSYET";
    private static final String TRACE_MASKF = "XLDSSYEF";
    private static final String TRACE_MASKD = "XLDSSYED";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");
    private static final String _systemEventTitle = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.systemevent.title").toString();
    private Map _map;

    public SystemEventExpander(Map map) throws IOException, HException {
        Trace.trace(TRACE_MASKT, "<> SystemEventExpander()");
        this._map = map;
        this.displaySystemEvent();
    }

    private void displaySystemEvent() throws IOException {
        Trace.trace(TRACE_MASKT, "-> SystemEventExpander.displaySystemEvent()");
        ExpanderData expanderData = GetExpanderData.getData(this._map);
        if (expanderData.getDataExists()) {
            String msg;
            Log log = expanderData.getLog();
            SystemEventLog systemEventLog = new SystemEventLog(log);
            String key = systemEventLog.getEventText().getKey();
            Trace.trace(TRACE_MASKF, "system event KEY=[" + key + "]");
            UserContext userContext = UserContext.getCurrentUserContext();
            Locale locale = null;
            locale = userContext == null ? Locale.getDefault() : userContext.getLocale();
            if (locale == null) {
                Trace.trace(TRACE_MASKF, "LOCALE IS NULL");
            }
            if ((msg = systemEventLog.getEventText().toString(locale)).equals(key)) {
                Trace.trace(TRACE_MASKF, "system event and the key are equal. SysEvent msg not found");
                HttpServletRequest request = expanderData.getRequest();
                HttpServletResponse response = expanderData.getResponse();
                LogServletMsg.displayMsg(request, response, _systemEventTitle, "XLDSNSYM", MsgType.INFORMATION_MESSAGE);
            } else {
                Trace.trace(TRACE_MASKF, "System event=" + systemEventLog.getEventText());
                PrintWriter out = expanderData.getResponse().getWriter();
                out.print("<html> <script src='/js/servlettask/keys.js'></script><head><title>" + _systemEventTitle + "</title></head>" + "<body onload='window.focus(); hideCancel();' > <pre>" + LogServlet.HTML_BACK + "<br>&nbsp;<br>" + systemEventLog.getEventText() + "</pre> </body>" + "</html>");
            }
        }
        Trace.trace(TRACE_MASKT, "<- SystemEventExpander.displaySystemEvent()");
    }
}

